# Queen Florist Admin Panel

Backend responsif dengan sistem login terenkripsi dan fungsi CRUD lengkap untuk manajemen event Queen Florist.

## 📁 Struktur Folder

```
mimin/
├── css/
│   ├── login.css          # Styles untuk halaman login
│   └── admin.css          # Styles untuk dashboard admin
├── js/
│   ├── login.js           # JavaScript untuk login
│   └── admin.js           # JavaScript untuk dashboard
├── api/
│   ├── config.php         # Konfigurasi database dan security
│   ├── login.php          # API untuk login
│   ├── check_session.php  # API untuk validasi session
│   ├── logout.php         # API untuk logout
│   └── events.php         # API untuk CRUD events
├── database.sql           # File database SQL
├── login.html             # Halaman login
├── index.html             # Dashboard admin
└── README.md              # Dokumentasi
```

## 🚀 Instalasi

### 1. Database Setup

Import file `database.sql` ke MySQL:

```sql
mysql -u root -p queen_florist < database.sql
```

### 2. Konfigurasi

Edit file `api/config.php` jika perlu:

```php
// Database Configuration
define('DB_HOST', 'localhost');
define('DB_NAME', 'queen_florist');
define('DB_USER', 'root');
define('DB_PASS', '');

// Admin Configuration
define('ADMIN_USERNAME', 'admin');
define('ADMIN_PASSWORD_HASH', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi'); // password: admin123
```

### 3. Deploy

Copy folder `mimin` ke web server (XAMPP, WAMP, dll):

```bash
cp -r mimin /path/to/web/root/
```

Akses melalui browser:
- Login: `http://localhost/mimin/login.html`
- Dashboard: `http://localhost/mimin/`

## 🔐 Login Credentials

- **Username**: `admin`
- **Password**: `admin123`

## 📊 Database Schema

### Tabel Events

```sql
CREATE TABLE events (
    id INT AUTO_INCREMENT PRIMARY KEY,
    month TINYINT NOT NULL COMMENT 'Bulan (1-12)',
    day TINYINT NOT NULL COMMENT 'Hari (1-31)',
    title VARCHAR(255) NOT NULL COMMENT 'Judul event',
    description TEXT COMMENT 'Deskripsi event',
    is_active TINYINT(1) DEFAULT 1 COMMENT 'Status aktif (1=aktif, 0=non-aktif)',
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
);
```

### Tabel Admin Sessions

```sql
CREATE TABLE admin_sessions (
    id INT AUTO_INCREMENT PRIMARY KEY,
    session_id VARCHAR(255) NOT NULL UNIQUE,
    admin_id VARCHAR(50) NOT NULL,
    ip_address VARCHAR(45),
    user_agent TEXT,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    expires_at TIMESTAMP NOT NULL,
    is_active TINYINT(1) DEFAULT 1
);
```

## 🔧 API Endpoints

### Authentication

#### POST `/api/login.php`
Login admin untuk mendapatkan session token.

**Request:**
```json
{
    "username": "admin",
    "password": "admin123"
}
```

**Response:**
```json
{
    "success": true,
    "message": "Login successful",
    "data": {
        "session_id": "abc123...",
        "username": "admin",
        "expires_in": 86400
    }
}
```

#### POST `/api/check_session.php`
Validasi session token.

#### POST `/api/logout.php`
Logout dan hapus session.

### Events Management

#### GET `/api/events.php`
Mendapatkan semua events.

**Headers:**
```
Authorization: Bearer {session_id}
```

**Query Parameters:**
- `month` (optional): Filter by month (1-12)
- `active_only` (optional): Hanya event aktif

#### POST `/api/events.php`
Membuat event baru.

**Request:**
```json
{
    "month": 12,
    "day": 25,
    "title": "Christmas Special",
    "description": "Christmas celebration with special flowers",
    "is_active": 1
}
```

#### PUT `/api/events.php?id={id}`
Update event existing.

#### DELETE `/api/events.php?id={id}`
Hapus event.

## 🎨 Fitur

### ✅ Keamanan
- Password terenkripsi dengan `password_hash()`
- Session management dengan JWT-like tokens
- SQL injection protection dengan prepared statements
- XSS protection dengan input sanitization
- CORS headers untuk cross-origin requests

### ✅ Responsif
- Mobile-first design
- Breakpoints untuk tablet dan desktop
- Touch-friendly interface
- Optimized untuk semua ukuran layar

### ✅ CRUD Operations
- **Create**: Tambah event baru dengan validasi
- **Read**: Tampilkan semua events dengan search dan filter
- **Update**: Edit event existing
- **Delete**: Hapus event dengan konfirmasi

### ✅ User Experience
- Loading states untuk semua operasi async
- Toast notifications untuk feedback
- Modal dialogs untuk form editing
- Real-time statistics dashboard
- Search dan filter functionality
- Dark mode support

## 🔒 Security Features

1. **Password Encryption**: Menggunakan `password_hash()` dengan bcrypt
2. **Session Management**: Token-based authentication dengan expiry
3. **Input Validation**: Comprehensive validation untuk semua input
4. **SQL Injection Prevention**: Prepared statements untuk semua query
5. **XSS Protection**: HTML escaping untuk output
6. **CORS Configuration**: Proper headers untuk API security

## 📱 Responsive Design

- **Mobile**: < 768px
- **Tablet**: 768px - 1024px  
- **Desktop**: > 1024px

### Mobile Optimizations
- Stacked layouts
- Touch-friendly buttons (min 44px)
- Simplified navigation
- Optimized form inputs

## 🛠️ Teknologi

- **Frontend**: HTML5, CSS3, JavaScript (ES6+)
- **Backend**: PHP 7.4+
- **Database**: MySQL 5.7+
- **Styling**: Custom CSS dengan CSS Grid dan Flexbox
- **Icons**: Emoji icons untuk universal compatibility

## 📝 Error Handling

Semua error responses mengikuti format standar:

```json
{
    "success": false,
    "message": "Error description",
    "data": null
}
```

HTTP Status Codes:
- `200`: Success
- `201`: Created
- `400`: Bad Request
- `401`: Unauthorized
- `404`: Not Found
- `405`: Method Not Allowed
- `409`: Conflict
- `500`: Internal Server Error

## 🔄 Session Flow

1. **Login**: POST ke `/api/login.php` dengan credentials
2. **Receive Token**: Dapatkan session ID dalam response
3. **Store Token**: Simpan di localStorage browser
4. **Include Token**: Kirim token di Authorization header untuk request berikutnya
5. **Auto-refresh**: Token otomatis diperpanjang dengan activity
6. **Logout**: POST ke `/api/logout.php` untuk hapus session

## 🚀 Performance Optimizations

- Minimal CSS dengan efficient selectors
- Lazy loading untuk large datasets
- Optimized database queries dengan proper indexing
- Minimal JavaScript dengan efficient DOM manipulation
- Compressed responses dengan proper headers

## 🐛 Troubleshooting

### Common Issues

1. **Database Connection Failed**
   - Check MySQL service running
   - Verify database credentials in config.php
   - Ensure database exists

2. **Login Failed**
   - Verify admin credentials
   - Check password hash in config.php
   - Clear browser localStorage

3. **Session Expired**
   - Session expires setelah 24 hours
   - Auto-redirect ke login page
   - Check session table in database

4. **CORS Issues**
   - Check API headers in config.php
   - Verify preflight request handling
   - Check browser console for errors

### Debug Mode

Enable error reporting di `config.php`:

```php
error_reporting(E_ALL);
ini_set('display_errors', 1);
```

## 📞 Support

Untuk bantuan atau pertanyaan:
- Check error logs di browser console
- Verify network requests di DevTools
- Check PHP error logs di server
- Review database connection status

---

**Queen Florist Admin Panel** - Backend responsif dengan keamanan tinggi dan user experience terbaik.